export default function GalleryPage() {
  const galleryItems = [
    { id: 1, title: 'Full Detail - BMW M3', category: 'Exterior' },
    { id: 2, title: 'Interior Restoration - Mercedes S-Class', category: 'Interior' },
    { id: 3, title: 'Paint Correction - Porsche 911', category: 'Paint' },
    { id: 4, title: 'Ceramic Coating - Tesla Model S', category: 'Coating' },
    { id: 5, title: 'Deep Clean - Range Rover', category: 'Interior' },
    { id: 6, title: 'Complete Detail - Ford Mustang', category: 'Full Detail' },
    { id: 7, title: 'Engine Bay Cleaning - Audi RS7', category: 'Engine' },
    { id: 8, title: 'Wheel Restoration - Lamborghini Huracan', category: 'Wheels' },
  ]

  return (
    <div className= "min-h-screen bg-gray-50" >
    <div className="container py-20" >
      <h1 className="text-5xl font-bold text-center mb-12 text-gray-900" >
        Our Work Gallery
          </h1>

          < p className = "text-center text-xl text-gray-600 mb-12 max-w-3xl mx-auto" >
            Browse through our portfolio of professional detailing work.Each vehicle receives our signature attention to detail.
        </p>

              < div className = "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8" >
              {
                galleryItems.map((item) => (
                  <div key= { item.id } className = "card group cursor-pointer" >
                  <div className="aspect-video bg-gradient-to-br from-gray-200 to-gray-300 rounded-lg mb-4 flex items-center justify-center overflow-hidden" >
                <span className="text-gray-500 text-lg group-hover:scale-110 transition-transform" >
                { item.title }
                </span>
                </div>
                < h3 className = "font-semibold text-lg mb-1" > { item.title } </h3>
                < span className = "inline-block bg-red-600/10 text-red-600 px-3 py-1 rounded-full text-sm" >
                { item.category }
                </span>
                </div>
                ))
              }
                </div>

                < div className = "text-center mt-12" >
                  <p className="text-gray-600 mb-4" >
                    Want to see your vehicle featured in our gallery ?
                      </p>
                      < a href = "/contact" className = "btn-primary" >
                        Book Your Detail Today
                          </a>
                          </div>
                          </div>
                          </div>
  )
}
